<?php
namespace App\Repositories;

use App\Models\User;
use App\Traits\ApiResponser;
use Carbon\Carbon;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\DB;

class PaymentRepository
{
    use ApiResponser;

    public function __construct(){
    }

    public function vaRegistration($request){
        try {
            $is_error   = $request['is_error'] ?? false;
            $va         = $request['VirtualAccount'] ?? "0123456789012345678";
            if($is_error){
                $status = [
                    "IsError"       => true,
                    "ResponseCode"  => "12",
                    "ErrorDesc"     => "Gagal"
                ];
            }else{
                $status = [
                    "IsError"       => false,
                    "ResponseCode"  => "00",
                    "ErrorDesc"     => "Success"
                ];
            }
            $respon = [
                "VirtualAccount" => $va,
                "Nama"           => "BANK JATIM",
                "Status"         => $status,
            ];
            return response()->json($respon);
        } catch (\Throwable $th) {
            $respon = [
                "VirtualAccount" => "0123456789012345678",
                "Nama"           => "BANK JATIM",
                "Status"         => [
                    "IsError"       => true,
                    "ResponseCode"  => "12",
                    "ErrorDesc"     => "Gagal"
                ],
            ];
            return response()->json($respon);
        }
    }

    public function vaCheckStatus($request){
        try {
            $is_error   = $request['is_error'] ?? false;
            $va         = $request['VirtualAccount'] ?? "0123456789012345678";
            if($is_error){
                $status = [
                    "IsError"       => true,
                    "ResponseCode"  => "12",
                    "ErrorDesc"     => "Gagal"
                ];
            }else{
                $status = [
                    "IsError"       => false,
                    "ResponseCode"  => "00",
                    "ErrorDesc"     => "Success"
                ];
            }
            $respon = [
                "VirtualAccount" => $va,
                "Nama" => "DUMMY VA KATEPAY",
                "ReffInstitusi" => "114715",
                "TotalTagihan" => 1,
                "Sign" => "+",
                "TanggalExp" => "20501231",
                "Berita1" => "INFO 1",
                "Berita2" => "INFO 2",
                "Berita3" => "INFO 3",
                "Berita4" => "INFO 4",
                "Berita5" => "INFO 5",
                "Keterangan" => "",
                "Biaya" => "0",
                "Flag" => "P",
                "FlagLunas" => "N",
                "Status" => $status
            ];
            return response()->json($respon);
        } catch (\Throwable $th) {
            $respon = [
                "VirtualAccount" => $va,
                "Nama" => "DUMMY VA KATEPAY",
                "ReffInstitusi" => "114715",
                "TotalTagihan" => 1,
                "Sign" => "+",
                "TanggalExp" => "20501231",
                "Berita1" => "INFO 1",
                "Berita2" => "INFO 2",
                "Berita3" => "INFO 3",
                "Berita4" => "INFO 4",
                "Berita5" => "INFO 5",
                "Keterangan" => "",
                "Biaya" => "0",
                "Flag" => "P",
                "FlagLunas" => "N",
                "Status"         => [
                    "IsError"       => true,
                    "ResponseCode"  => "12",
                    "ErrorDesc"     => "Gagal"
                ],
            ];
            return response()->json($respon);
        }
    }

    public function qris($request){
        try {
            $is_error   = $request['is_error'] ?? false;
            if($is_error){
                $responsCode = "412";
                $status      = false;
            }else{
                $responsCode = "00";
                $status      = true;
            }

            $respon = [
                "responsCode"   => $responsCode,
                "totalAmount"   => $request['amount'] ?? 111,
                "qrValue"       => Carbon::now()->timestamp,
                "amount"        => $request['amount'] ?? 111,
                "expiredDate"   => $request['expiredDate'] ?? Carbon::now()->format('Y-m-d H:i:s'),
                "nmid"          => "ID1020036849633",
                "billNumber"    => $request['billNumber'] ?? "111",
                "merchantPan"   => "9360011400000022721",
                "invoice_number"=> $request['merchantPan'] ?? "merchantPan",
                "status"        => $status,
                "merchantName"  => "BPP UPT TAHURA MALANG"
            ];
            return response()->json($respon);
        } catch (\Throwable $th) {
            $respon = [
                "responsCode"   => "412",
                "totalAmount"   => $request['amount'] ?? 111,
                "qrValue"       => Carbon::now()->timestamp,
                "amount"        => $request['amount'] ?? 111,
                "expiredDate"   => $request['expiredDate'] ?? Carbon::now()->format('Y-m-d H:i:s'),
                "nmid"          => "ID1020036849633",
                "billNumber"    => $request['billNumber'] ?? "111",
                "merchantPan"   => "9360011400000022721",
                "invoice_number"=> $request['merchantPan'] ?? "merchantPan",
                "status"        => false,
                "merchantName"  => "BPP UPT TAHURA MALANG"
            ];
            return response()->json($respon);
        }
    }

}
