<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Repositories\PaymentRepository;
use App\Traits\ApiResponser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class PaymentController extends Controller
{
    use ApiResponser;
    protected $paymentRepository;
    public function __construct(PaymentRepository $paymentRepository)
    {
        $this->middleware('auth:api', ['except' => ['va_registration', 'va_checkstatus', 'qris']]);
        $this->paymentRepository = $paymentRepository;
    }

    public function va_registration(Request $request){
        return $this->paymentRepository->vaRegistration($request);
    }

    public function va_checkstatus(Request $request){
        return $this->paymentRepository->vaCheckStatus($request);
    }

    public function qris(Request $request){
        return $this->paymentRepository->qris($request);
    }



}
